<?php

/*
|--------------------------------------------------------------------------
| Validation Language Lines
|--------------------------------------------------------------------------
|
| The following language lines contain the default error messages used by
| the validator class. Some of these rules have multiple versions such
| as the size rules. Feel free to tweak each of these messages here.
|
*/

return [
    'accepted'             => ':attribute સ્વીકૃત હોવું જોઈએ.',
    'accepted_if'          => 'The :attribute must be accepted when :other is :value.',
    'active_url'           => ':attribute માન્ય URL નથી.',
    'after'                => ':attribute પછી તારીખ હોવી જોઈએ :તારીખ.',
    'after_or_equal'       => ':attribute પછી તારીખ કે સમાંતર હોવું જોઈએ :તારીખ.',
    'alpha'                => ':attribute માત્ર અક્ષરોનો જ સમાવેશ કરી શકે.',
    'alpha_dash'           => ':attribute માત્ર અક્ષરો, આંકડાઓ, ડેશ અને ની નીચે લીટીનો જ સમાવેશ કરી શકે.',
    'alpha_num'            => ':attribute માત્ર અક્ષરો તથા આંકડાઓનો જ સમાવેશ કરી શકે.',
    'array'                => ':attribute ગોઠવણીમાં હોવું જોઈએ.',
    'before'               => ':attribute પહેલાં તારીખ હોવી જોઈએ :તારીખ.',
    'before_or_equal'      => ':attribute પહેલાં તારીખ કે સમાંતર હોવું જોઈએ :તારીખ.',
    'between'              => [
        'array'   => ':attribute ની વચ્ચે હોવું જોઈએ :min અને :max વસ્તુઓ.',
        'file'    => ':attribute ની વચ્ચે હોવું જોઈએ :min અને :max કિલોબાઇટ્સ.',
        'numeric' => ':attribute ની વચ્ચે હોવું જોઈએ :min અને :max.',
        'string'  => ':attribute ની વચ્ચે હોવું જોઈએ :min અને :max અક્ષરો.',
    ],
    'boolean'              => ':attribute પ્રવૃત્તિ ક્ષેત્ર ખરું કે ખોટું હોવું જોઈએ.',
    'confirmed'            => ':attribute પુષ્ટિકરણ બંધબેસતું નથી.',
    'current_password'     => 'The password is incorrect.',
    'date'                 => ':attribute માન્ય તારીખ નથી.',
    'date_equals'          => ':attribute સમાંતર તારીખ હોવી જોઈએ :તારીખ.',
    'date_format'          => ':attribute ગોઠવણ સાથે બંધબેસતું નથી :ગોઠવણ.',
    'declined'             => 'The :attribute must be declined.',
    'declined_if'          => 'The :attribute must be declined when :other is :value.',
    'different'            => ':attribute અને :other અલગ હોવું જોઈએ.',
    'digits'               => ':attribute હોવું જોઈએ  :digits અંક.',
    'digits_between'       => ':attribute વચ્ચે હોવું જોઈએ :min અને :max અંક.',
    'dimensions'           => ':attribute છબીનું પરિમાણ અમાન્ય છે.',
    'distinct'             => ':attribute પ્રવૃત્તિ ક્ષેત્રનું નકલી મૂલ્ય છે.',
    'email'                => ':attribute માન્ય ઈમેઈલ એડ્રેસ હોવું જોઈએ.',
    'ends_with'            => ':attribute નીચેમાંથી એક પ્રમાણે પૂરું થતું હોવું જોઈએ :values.',
    'enum'                 => 'The selected :attribute is invalid.',
    'exists'               => 'પસંદ કરાયેલ :attribute અમાન્ય છે.',
    'file'                 => ':attribute એક ફાઈલ હોવી જોઈએ.',
    'filled'               => ':attribute પ્રવૃત્તિ ક્ષેત્રનું મૂલ્ય હોવું જોઈએ.',
    'gt'                   => [
        'array'   => ':attribute ના કરતાં વિશેષ :value વસ્તુઓ.',
        'file'    => ':attribute થી વિશેષ હોવું જોઈએ :value કિલો બાઇટ્સ.',
        'numeric' => ':attribute થી વિશેષ હોવું જોઈએ :value.',
        'string'  => ':attribute થી વિશેષ હોવું જોઈએ :value મૂલ્ય અક્ષરો.',
    ],
    'gte'                  => [
        'array'   => ':attribute હોવું જોઈએ :value વસ્તુઓ કે વિશેષ.',
        'file'    => ':attribute થી વિશેષ અથવા સમાંતર હોવું જોઈએ :value કિલો બાઇટ્સ.',
        'numeric' => ':attribute થી વિશેષ અથવા સમાંતર હોવું જોઈએ :value.',
        'string'  => ':attribute થી વિશેષ અથવા સમાંતર હોવું જોઈએ :value મૂલ્ય અક્ષરો.',
    ],
    'image'                => ':attribute છબી હોવી જોઈએ.',
    'in'                   => ':attribute અમાન્ય છે.',
    'in_array'             => ':attribute માં પ્રવૃત્તિ ક્ષેત્ર અસ્તિત્વ ધરાવતું નથી :other.',
    'integer'              => ':attribute પૂર્ણ સંખ્યા હોવી જોઈએ.',
    'ip'                   => ':attribute માન્ય IP address હોવું જોઈએ.',
    'ipv4'                 => ':attribute માન્ય IPv4 address હોવું જોઈએ.',
    'ipv6'                 => ':attribute માન્ય IPv6 address હોવું જોઈએ.',
    'json'                 => ':attribute માન્ય JSON શબ્દમાળા હોવી જોઈએ.',
    'lt'                   => [
        'array'   => ':attribute ઓછું હોવું જોઈએ :value વસ્તુઓ.',
        'file'    => ':attribute ઓછું હોવું જોઈએ :value કિલો બાઇટ્સ.',
        'numeric' => ':attribute ઓછું હોવું જોઈએ :value.',
        'string'  => ':attribute ઓછું હોવું જોઈએ :value અક્ષરો.',
    ],
    'lte'                  => [
        'array'   => ':attribute ના કરતા વધુ ન હોવું જોઈએ :value વસ્તુઓ.',
        'file'    => ':attribute ઓછું કે સમાંતર હોવું જોઈએ :value કિલો બાઇટ્સ.',
        'numeric' => ':attribute ઓછું કે સમાંતર હોવું જોઈએ :value.',
        'string'  => ':attribute ઓછું કે સમાંતર હોવું જોઈએ :value અક્ષરો.',
    ],
    'mac_address'          => 'The :attribute must be a valid MAC address.',
    'max'                  => [
        'array'   => ':attribute ના કરતાં વધુ ન હોઈ શકે :max વસ્તુઓ.',
        'file'    => ':attribute મોટું ન હોઈ શકે :max કિલો બાઇટ્સ.',
        'numeric' => ':attribute મોટું ન હોઈ શકે :max.',
        'string'  => ':attribute મોટું ન હોઈ શકે :max અક્ષરો.',
    ],
    'mimes'                => ':attribute પ્રકારની ફાઈલ હોવી જોઈએ :values.',
    'mimetypes'            => ':attribute પ્રકારની ફાઈલ હોવી જોઈએ :values.',
    'min'                  => [
        'array'   => ':attribute  હોવું જ જોઈએ :min વસ્તુઓ.',
        'file'    => ':attribute ઓછામાં ઓછું હોવું જોઈએ :min કિલો બાઇટ્સ.',
        'numeric' => ':attribute ઓછામાં ઓછું હોવું જોઈએ :min.',
        'string'  => ':attribute ઓછામાં ઓછું હોવું જોઈએ :min અક્ષરો.',
    ],
    'multiple_of'          => 'The :attribute must be a multiple of :value.',
    'not_in'               => 'પસંદ કરાયેલ :attribute અમાન્ય છે.',
    'not_regex'            => ':attribute અમાન્ય ગોઠવણ છે.',
    'numeric'              => ':attribute આંક હોવો જોઈએ.',
    'password'             => 'The password is incorrect.',
    'present'              => ':attribute પ્રવૃત્તિ ક્ષેત્ર હાજર હોવું જોઈએ.',
    'prohibited'           => 'The :attribute field is prohibited.',
    'prohibited_if'        => 'The :attribute field is prohibited when :other is :value.',
    'prohibited_unless'    => 'The :attribute field is prohibited unless :other is in :values.',
    'prohibits'            => 'The :attribute field prohibits :other from being present.',
    'regex'                => ':attribute અમાન્ય ગોઠવણ છે.',
    'required'             => ':attribute પ્રવૃત્તિ ક્ષેત્ર આવશ્યક છે.',
    'required_array_keys'  => 'The :attribute field must contain entries for: :values.',
    'required_if'          => ':attribute પ્રવૃત્તિ ક્ષેત્ર આવશ્યક છે જ્યારે :other છે :value.',
    'required_unless'      => ':attribute પ્રવૃત્તિ ક્ષેત્ર આવશ્યક છે સિવાય :other માં છે :values.',
    'required_with'        => ':attribute પ્રવૃત્તિ ક્ષેત્ર આવશ્યક છે જ્યારે :values હાજર હોય.',
    'required_with_all'    => ':attribute પ્રવૃત્તિ ક્ષેત્ર આવશ્યક છે જ્યારે :values હાજર હોય.',
    'required_without'     => ':attribute પ્રવૃત્તિ ક્ષેત્ર આવશ્યક છે જ્યારે :values હાજર ન હોય.',
    'required_without_all' => ':attribute પ્રવૃત્તિ ક્ષેત્ર આવશ્યક છે જ્યારે કશું પણ :values હાજર હોય.',
    'same'                 => ':attribute અને :other બંધબેસતું હોવું જોઈએ.',
    'size'                 => [
        'array'   => ':attribute સમાવેશ કરતું હોવું જોઈએ : કદ વસ્તુઓ.',
        'file'    => ':attribute હોવું જોઈએ :size કિલો બાઇટ્સ.',
        'numeric' => ':attribute હોવું જોઈએ :કદ.',
        'string'  => ':attribute હોવું જોઈએ :size અક્ષરો.',
    ],
    'starts_with'          => ':attribute નીચેમાંથી કોઈએક વડે શરૂ થતું હોવું જોઈએ :values.',
    'string'               => ':attribute શબ્દમાળા હોવી જોઈએ.',
    'timezone'             => ':attribute  માન્ય પરિક્ષેત્ર હોવું જોઈએ.',
    'unique'               => ':attribute પહેલેથી લઈ લેવામાં આવેલ છે.',
    'uploaded'             => ':attribute અપલોડ થવામાં નિષ્ફળ.',
    'url'                  => ':attribute ગોઠવણ અમાન્ય છે.',
    'uuid'                 => ':attribute માન્ય UUID હોવું જોઈએ.',
    'custom'               => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
];
